class X2Effect_BioticStrength extends X2Effect_Persistent config(Biotics);

var config float Divider;

function int GetAttackingDamageModifier(XComGameState_Effect EffectState, XComGameState_Unit Attacker, Damageable TargetDamageable, XComGameState_Ability AbilityState, const out EffectAppliedData AppliedData, const int CurrentDamage, optional XComGameState NewGameState)
{
	local XComGameState_Unit TargetUnit;
	local GameRulesCache_VisibilityInfo VisInfo;
	local bool IsBioticAbility;
	local int BonusDamage;

	TargetUnit = XComGameState_Unit(TargetDamageable);
	if(AbilityState.GetMyTemplate().AbilitySourceName == 'eAbilitySource_Psionic' && (AbilityState.GetMyTemplateName() != 'RM_RuptureField' && AbilityState.GetMyTemplateName() != 'RM_Singularity'))
	{
		IsBioticAbility = true;
	}
	if (IsBioticAbility && TargetUnit != None && class'XComGameStateContext_Ability'.static.IsHitResultHit(AppliedData.AbilityResultContext.HitResult))
	{
		BonusDamage = Attacker.GetCurrentStat(eStat_PsiOffense) / Divider;
		//200 / 50 = 4 points of bonus damage
		return BonusDamage;
	}
	return 0;
}

DefaultProperties
{
	DuplicateResponse = eDupe_Ignore
}